/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsOptions;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.WorldTemplate;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.RealmsConfirmResultListener;
import com.mojang.realmsclient.gui.RealmsConnectTask;
import com.mojang.realmsclient.gui.RealmsConstants;
import com.mojang.realmsclient.gui.RealmsHideableButton;
import com.mojang.realmsclient.gui.screens.RealmsBackupScreen;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongConfirmationScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.RealmsPlayerScreen;
import com.mojang.realmsclient.gui.screens.RealmsResetWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsScreenWithCallback;
import com.mojang.realmsclient.gui.screens.RealmsSelectWorldTemplateScreen;
import com.mojang.realmsclient.gui.screens.RealmsSettingsScreen;
import com.mojang.realmsclient.gui.screens.RealmsSlotOptionsScreen;
import com.mojang.realmsclient.gui.screens.RealmsStartMinigameWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsSubscriptionInfoScreen;
import com.mojang.realmsclient.util.RealmsTasks;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Random;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsMth;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.RealmsSharedConstants;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class RealmsConfigureWorldScreen
extends RealmsScreenWithCallback<WorldTemplate>
implements RealmsConfirmResultListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TOGGLE_ON_ICON_LOCATION = "realms:textures/gui/realms/toggle_on_icon.png";
    private static final String TOGGLE_OFF_ICON_LOCATION = "realms:textures/gui/realms/toggle_off_icon.png";
    private static final String OFF_ICON_LOCATION = "realms:textures/gui/realms/off_icon.png";
    private static final String EXPIRED_ICON_LOCATION = "realms:textures/gui/realms/expired_icon.png";
    private static final String SLOT_FRAME_LOCATION = "realms:textures/gui/realms/slot_frame.png";
    private String toolTip;
    private final RealmsScreen lastScreen;
    private RealmsServer serverData;
    private volatile long serverId;
    private int left_x;
    private int right_x;
    private int default_button_width = 80;
    private int default_button_offset = 5;
    private static final int BUTTON_BACK_ID = 0;
    private static final int BUTTON_CLOSE_ID = 1;
    private static final int BUTTON_PLAYERS_ID = 2;
    private static final int BUTTON_SETTINGS_ID = 3;
    private static final int BUTTON_SUBSCRIPTION_ID = 4;
    private static final int BUTTON_OPTIONS_ID = 5;
    private static final int BUTTON_BACKUP_ID = 6;
    private static final int BUTTON_RESET_WORLD_ID = 7;
    private static final int BUTTON_SWITCH_MINIGAME_ID = 8;
    private static final int SWITCH_SLOT_ID = 9;
    private RealmsButton playersButton;
    private RealmsButton settingsButton;
    private RealmsButton subscriptionButton;
    private RealmsHideableButton optionsButton;
    private RealmsHideableButton backupButton;
    private RealmsHideableButton resetWorldButton;
    private RealmsHideableButton switchMinigameButton;
    private boolean stateChanged;
    private boolean openButtonHovered = false;
    private boolean closeButtonHovered = false;
    private int hoveredSlot = -1;
    private int animTick;
    private int clicks = 0;
    private boolean hoveredActiveSlot = false;
    private final int randomMinigameImage;

    public RealmsConfigureWorldScreen(RealmsScreen lastScreen, long serverId) {
        this.lastScreen = lastScreen;
        this.serverId = serverId;
        this.randomMinigameImage = RealmsConstants.RANDOM_MINIGAME_IMAGES.get(new Random().nextInt(RealmsConstants.RANDOM_MINIGAME_IMAGES.size()));
    }

    public void mouseEvent() {
        super.mouseEvent();
    }

    public void init() {
        if (this.serverData == null) {
            this.fetchServerData(this.serverId);
        }
        this.left_x = this.width() / 2 - 187;
        this.right_x = this.width() / 2 + 190;
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
        this.playersButton = RealmsConfigureWorldScreen.newButton((int)2, (int)this.centerButton(0, 3), (int)RealmsConstants.row(1), (int)this.default_button_width, (int)20, (String)RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.buttons.players"));
        this.buttonsAdd(this.playersButton);
        this.settingsButton = RealmsConfigureWorldScreen.newButton((int)3, (int)this.centerButton(1, 3), (int)RealmsConstants.row(1), (int)this.default_button_width, (int)20, (String)RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.buttons.settings"));
        this.buttonsAdd(this.settingsButton);
        this.subscriptionButton = RealmsConfigureWorldScreen.newButton((int)4, (int)this.centerButton(2, 3), (int)RealmsConstants.row(1), (int)this.default_button_width, (int)20, (String)RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.buttons.subscription"));
        this.buttonsAdd(this.subscriptionButton);
        this.optionsButton = new RealmsHideableButton(5, this.leftButton(0), RealmsConstants.row(13) - 5, this.default_button_width, 20, RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.buttons.options"));
        this.buttonsAdd(this.optionsButton);
        this.backupButton = new RealmsHideableButton(6, this.leftButton(1), RealmsConstants.row(13) - 5, this.default_button_width, 20, RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.backup"));
        this.buttonsAdd(this.backupButton);
        this.resetWorldButton = new RealmsHideableButton(7, this.leftButton(2), RealmsConstants.row(13) - 5, this.default_button_width, 20, RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.buttons.resetworld"));
        this.buttonsAdd(this.resetWorldButton);
        this.switchMinigameButton = new RealmsHideableButton(8, this.leftButton(0), RealmsConstants.row(13) - 5, this.default_button_width + 20, 20, RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.buttons.switchminigame"));
        this.buttonsAdd(this.switchMinigameButton);
        this.buttonsAdd(RealmsConfigureWorldScreen.newButton((int)0, (int)(this.right_x - this.default_button_width + 8), (int)(RealmsConstants.row(13) - 5), (int)(this.default_button_width - 10), (int)20, (String)RealmsConfigureWorldScreen.getLocalizedString((String)"gui.back")));
        this.backupButton.active(true);
        if (this.serverData == null) {
            this.hideMinigameButtons();
            this.hideRegularButtons();
            this.playersButton.active(false);
            this.settingsButton.active(false);
            this.subscriptionButton.active(false);
        } else {
            this.disableButtons();
            if (this.isMinigame()) {
                this.hideRegularButtons();
            } else {
                this.hideMinigameButtons();
            }
        }
    }

    private int leftButton(int i) {
        return this.left_x + i * (this.default_button_width + this.default_button_offset);
    }

    private int centerButton(int i, int total) {
        return this.width() / 2 - (total * (this.default_button_width + this.default_button_offset) - this.default_button_offset) / 2 + i * (this.default_button_width + this.default_button_offset);
    }

    public void tick() {
        ++this.animTick;
        --this.clicks;
        if (this.clicks < 0) {
            this.clicks = 0;
        }
    }

    public void render(int xm, int ym, float a) {
        this.toolTip = null;
        this.closeButtonHovered = false;
        this.openButtonHovered = false;
        this.hoveredActiveSlot = false;
        this.hoveredSlot = -1;
        this.renderBackground();
        this.drawCenteredString(RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.title"), this.width() / 2, 17, 0xFFFFFF);
        this.drawCenteredString(RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.worlds.title"), this.width() / 2, RealmsConstants.row(4), 0xFFFFFF);
        super.render(xm, ym, a);
        if (this.serverData == null) {
            return;
        }
        String name = this.serverData.getName();
        int nameWidth = this.fontWidth(name);
        int nameColor = this.serverData.state == RealmsServer.State.CLOSED ? 0xA0A0A0 : 0x7FFF7F;
        this.drawCenteredString(name, this.width() / 2, 33, nameColor);
        int statusX = this.width() / 2 - nameWidth / 2 - 13;
        this.drawServerStatus(statusX, 33, xm, ym);
        for (Map.Entry<Integer, RealmsOptions> entry : this.serverData.slots.entrySet()) {
            this.drawSlotFrame(this.frame(entry.getKey()), RealmsConstants.row(5) + 5, xm, ym, this.serverData.activeSlot == entry.getKey() && !this.isMinigame(), entry.getValue().getSlotName(entry.getKey()), entry.getKey());
        }
        this.drawSlotFrame(this.frame(4), RealmsConstants.row(5) + 5, xm, ym, this.isMinigame(), "Minigame", 4);
        if (this.isMinigame()) {
            this.drawString(RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.current.minigame") + ": " + this.serverData.getMinigameName(), this.left_x + this.default_button_width + 20 + this.default_button_offset * 2, RealmsConstants.row(13), 0xFFFFFF);
        }
        if (this.toolTip != null) {
            this.renderMousehoverTooltip(this.toolTip, xm, ym);
        }
    }

    private int frame(int i) {
        return this.left_x + (i - 1) * 98;
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button instanceof RealmsHideableButton && !((RealmsHideableButton)button).getVisible()) {
            return;
        }
        switch (button.id()) {
            case 2: {
                Realms.setScreen((RealmsScreen)new RealmsPlayerScreen(this, this.serverData));
                break;
            }
            case 3: {
                Realms.setScreen((RealmsScreen)new RealmsSettingsScreen(this, this.serverData.clone()));
                break;
            }
            case 4: {
                Realms.setScreen((RealmsScreen)new RealmsSubscriptionInfoScreen(this, this.serverData.clone(), this.lastScreen));
                break;
            }
            case 0: {
                this.backButtonClicked();
                break;
            }
            case 8: {
                Realms.setScreen((RealmsScreen)new RealmsSelectWorldTemplateScreen(this, null, true));
                break;
            }
            case 6: {
                Realms.setScreen((RealmsScreen)new RealmsBackupScreen(this, this.serverData.clone()));
                break;
            }
            case 5: {
                Realms.setScreen((RealmsScreen)new RealmsSlotOptionsScreen(this, this.serverData.slots.get(this.serverData.activeSlot).clone(), this.serverData.worldType, this.serverData.activeSlot));
                break;
            }
            case 7: {
                Realms.setScreen((RealmsScreen)new RealmsResetWorldScreen(this, this.serverData.clone()));
                break;
            }
            default: {
                return;
            }
        }
    }

    public void keyPressed(char ch, int eventKey) {
        if (eventKey == 1) {
            this.backButtonClicked();
        }
    }

    private void backButtonClicked() {
        if (this.stateChanged) {
            ((RealmsMainScreen)this.lastScreen).removeSelection();
        }
        Realms.setScreen((RealmsScreen)this.lastScreen);
    }

    private void fetchServerData(final long worldId) {
        new Thread(){

            @Override
            public void run() {
                RealmsClient client = RealmsClient.createRealmsClient();
                try {
                    RealmsConfigureWorldScreen.this.serverData = client.getOwnWorld(worldId);
                    RealmsConfigureWorldScreen.this.disableButtons();
                    if (RealmsConfigureWorldScreen.this.isMinigame()) {
                        RealmsConfigureWorldScreen.this.showMinigameButtons();
                    } else {
                        RealmsConfigureWorldScreen.this.showRegularButtons();
                    }
                }
                catch (RealmsServiceException e) {
                    LOGGER.error("Couldn't get own world");
                    Realms.setScreen((RealmsScreen)new RealmsGenericErrorScreen(e.getMessage(), RealmsConfigureWorldScreen.this.lastScreen));
                }
                catch (IOException e) {
                    LOGGER.error("Couldn't parse response getting own world");
                }
            }
        }.start();
    }

    private void disableButtons() {
        this.playersButton.active(!this.serverData.expired);
        this.settingsButton.active(!this.serverData.expired);
        this.subscriptionButton.active(true);
        this.switchMinigameButton.active(!this.serverData.expired);
        this.optionsButton.active(!this.serverData.expired);
        this.resetWorldButton.active(!this.serverData.expired);
    }

    private void openTheWorld() {
        RealmsClient client = RealmsClient.createRealmsClient();
        try {
            Boolean openResult = client.open(this.serverData.id);
            if (openResult.booleanValue()) {
                this.stateChanged = true;
                this.serverData.state = RealmsServer.State.OPEN;
                this.init();
            }
        }
        catch (RealmsServiceException e) {
            LOGGER.error("Couldn't open world");
        }
        catch (IOException e) {
            LOGGER.error("Could not parse response opening world");
        }
    }

    private void closeTheWorld() {
        RealmsClient client = RealmsClient.createRealmsClient();
        try {
            boolean closeResult = client.close(this.serverData.id);
            if (closeResult) {
                this.stateChanged = true;
                this.serverData.state = RealmsServer.State.CLOSED;
                this.init();
            }
        }
        catch (RealmsServiceException e) {
            LOGGER.error("Couldn't close world");
        }
        catch (IOException e) {
            LOGGER.error("Could not parse response closing world");
        }
    }

    @Override
    public void confirmResult(boolean result, int id) {
        switch (id) {
            case 1: {
                if (result) {
                    this.closeTheWorld();
                }
                Realms.setScreen((RealmsScreen)this);
                break;
            }
            case 9: {
                if (result) {
                    this.switchSlot();
                    break;
                }
                Realms.setScreen((RealmsScreen)this);
            }
        }
    }

    public void mouseClicked(int x, int y, int buttonNum) {
        String line3;
        String line2;
        if (buttonNum == 0) {
            this.clicks += RealmsSharedConstants.TICKS_PER_SECOND / 3 + 1;
        } else {
            return;
        }
        if (this.closeButtonHovered && !this.serverData.expired) {
            this.openTheWorld();
        } else if (this.openButtonHovered && !this.serverData.expired) {
            line2 = RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.close.question.line1");
            line3 = RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.close.question.line2");
            Realms.setScreen((RealmsScreen)new RealmsLongConfirmationScreen(this, RealmsLongConfirmationScreen.Type.Info, line2, line3, true, 1));
        }
        if (this.hoveredSlot != -1) {
            if (this.hoveredSlot < 4) {
                line2 = RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.slot.switch.question.line1");
                line3 = RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.slot.switch.question.line2");
                Realms.setScreen((RealmsScreen)new RealmsLongConfirmationScreen(this, RealmsLongConfirmationScreen.Type.Info, line2, line3, true, 9));
            } else if (!this.isMinigame() && !this.serverData.expired) {
                Realms.setScreen((RealmsScreen)new RealmsStartMinigameWorldScreen(this, this.serverData.clone()));
            }
        } else if (this.clicks >= RealmsSharedConstants.TICKS_PER_SECOND / 2 && this.hoveredActiveSlot && this.serverData.state == RealmsServer.State.OPEN) {
            RealmsLongRunningMcoTaskScreen longRunningMcoTaskScreen = new RealmsLongRunningMcoTaskScreen(this, new RealmsConnectTask(this, this.serverData));
            longRunningMcoTaskScreen.start();
            Realms.setScreen((RealmsScreen)longRunningMcoTaskScreen);
        }
        super.mouseClicked(x, y, buttonNum);
    }

    protected void renderMousehoverTooltip(String msg, int x, int y) {
        if (msg == null) {
            return;
        }
        int rx = x + 12;
        int ry = y - 12;
        int width = this.fontWidth(msg);
        if (rx + width + 3 > this.right_x) {
            rx = rx - width - 20;
        }
        this.fillGradient(rx - 3, ry - 3, rx + width + 3, ry + 8 + 3, -1073741824, -1073741824);
        this.fontDrawShadow(msg, rx, ry, 0xFFFFFF);
    }

    private void drawServerStatus(int x, int y, int xm, int ym) {
        if (this.serverData.expired) {
            this.drawExpired(x, y, xm, ym);
        } else if (this.serverData.state == RealmsServer.State.CLOSED) {
            this.drawClose(x, y, xm, ym);
        } else if (this.serverData.state == RealmsServer.State.OPEN) {
            this.drawOpen(x, y, xm, ym);
        } else if (this.serverData.state == RealmsServer.State.ADMIN_LOCK) {
            this.drawLocked(x, y, xm, ym);
        }
    }

    private void drawExpired(int x, int y, int xm, int ym) {
        RealmsConfigureWorldScreen.bind((String)EXPIRED_ICON_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        RealmsScreen.blit((int)(x * 2), (int)(y * 2), (float)0.0f, (float)0.0f, (int)15, (int)15, (float)15.0f, (float)15.0f);
        GL11.glPopMatrix();
        if (xm >= x && xm <= x + 9 && ym >= y && ym <= y + 9) {
            this.toolTip = RealmsConfigureWorldScreen.getLocalizedString((String)"mco.selectServer.expired");
        }
    }

    private void drawOpen(int x, int y, int xm, int ym) {
        RealmsConfigureWorldScreen.bind((String)TOGGLE_ON_ICON_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        int xx = x - 12;
        RealmsScreen.blit((int)(xx * 2), (int)(y * 2), (float)0.0f, (float)0.0f, (int)32, (int)16, (float)32.0f, (float)16.0f);
        GL11.glPopMatrix();
        if (xm >= xx && xm <= xx + 16 && ym >= y && ym <= y + 8) {
            this.toolTip = RealmsConfigureWorldScreen.getLocalizedString((String)"mco.selectServer.closeserver");
            this.openButtonHovered = true;
        }
    }

    private void drawClose(int x, int y, int xm, int ym) {
        RealmsConfigureWorldScreen.bind((String)TOGGLE_OFF_ICON_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        int xx = x - 12;
        RealmsScreen.blit((int)(xx * 2), (int)(y * 2), (float)0.0f, (float)0.0f, (int)32, (int)16, (float)32.0f, (float)16.0f);
        GL11.glPopMatrix();
        if (xm >= xx && xm <= xx + 16 && ym >= y && ym <= y + 8) {
            this.toolTip = RealmsConfigureWorldScreen.getLocalizedString((String)"mco.selectServer.openserver");
            this.closeButtonHovered = true;
        }
    }

    private void drawLocked(int x, int y, int xm, int ym) {
        RealmsConfigureWorldScreen.bind((String)OFF_ICON_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        RealmsScreen.blit((int)(x * 2), (int)(y * 2), (float)0.0f, (float)0.0f, (int)15, (int)15, (float)15.0f, (float)15.0f);
        GL11.glPopMatrix();
    }

    private boolean isMinigame() {
        return this.serverData != null && this.serverData.worldType.equals((Object)RealmsServer.WorldType.MINIGAME);
    }

    private void drawSlotFrame(int x, int y, int xm, int ym, boolean active, String text, int i) {
        if (xm >= x && xm <= x + 80 && ym >= y && ym <= y + 80 && (!this.isMinigame() && this.serverData.activeSlot != i || this.isMinigame() && i != 4) && (i != 4 || !this.serverData.expired)) {
            this.hoveredSlot = i;
            String string = this.toolTip = i == 4 ? RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.slot.tooltip.minigame") : RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.slot.tooltip");
        }
        if (xm >= x && xm <= x + 80 && ym >= y && ym <= y + 80 && (!this.isMinigame() && this.serverData.activeSlot == i || this.isMinigame() && i == 4) && !this.serverData.expired && this.serverData.state == RealmsServer.State.OPEN) {
            this.hoveredActiveSlot = true;
            this.toolTip = RealmsConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.slot.tooltip.active");
        }
        if (i == 1) {
            RealmsConfigureWorldScreen.bind((String)"textures/gui/title/background/panorama_0.png");
        } else if (i == 2) {
            RealmsConfigureWorldScreen.bind((String)"textures/gui/title/background/panorama_2.png");
        } else if (i == 3) {
            RealmsConfigureWorldScreen.bind((String)"textures/gui/title/background/panorama_3.png");
        } else if (this.isMinigame()) {
            RealmsConfigureWorldScreen.bind((String)RealmsConstants.getMinigameImage(this.serverData.minigameId));
        } else {
            RealmsConfigureWorldScreen.bind((String)RealmsConstants.getMinigameImage(this.randomMinigameImage));
        }
        if (!active) {
            GL11.glColor4f((float)0.56f, (float)0.56f, (float)0.56f, (float)1.0f);
        } else {
            float c = 0.9f + 0.1f * RealmsMth.cos((float)((float)this.animTick * 0.2f));
            GL11.glColor4f((float)c, (float)c, (float)c, (float)1.0f);
        }
        RealmsScreen.blit((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)74, (int)74, (float)74.0f, (float)74.0f);
        RealmsConfigureWorldScreen.bind((String)SLOT_FRAME_LOCATION);
        if (this.hoveredSlot == i) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else if (!active) {
            GL11.glColor4f((float)0.56f, (float)0.56f, (float)0.56f, (float)1.0f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RealmsScreen.blit((int)x, (int)y, (float)0.0f, (float)0.0f, (int)80, (int)80, (float)80.0f, (float)80.0f);
        this.drawCenteredString(text, x + 40, y + 66, 0xFFFFFF);
    }

    private void hideRegularButtons() {
        this.optionsButton.setVisible(false);
        this.backupButton.setVisible(false);
        this.resetWorldButton.setVisible(false);
    }

    private void hideMinigameButtons() {
        this.switchMinigameButton.setVisible(false);
    }

    private void showRegularButtons() {
        this.optionsButton.setVisible(true);
        this.backupButton.setVisible(true);
        this.resetWorldButton.setVisible(true);
    }

    private void showMinigameButtons() {
        this.switchMinigameButton.setVisible(true);
    }

    public void saveSlotSettings() {
        RealmsClient client = RealmsClient.createRealmsClient();
        try {
            client.updateSlot(this.serverData.id, this.serverData.slots.get(this.serverData.activeSlot));
        }
        catch (RealmsServiceException e) {
            LOGGER.error("Couldn't save slot settings");
            Realms.setScreen((RealmsScreen)new RealmsGenericErrorScreen(e, (RealmsScreen)this));
            return;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Couldn't save slot settings");
        }
        Realms.setScreen((RealmsScreen)this);
    }

    public void saveSlotSettings(RealmsOptions options) {
        this.serverData.slots.put(this.serverData.activeSlot, options);
        this.saveSlotSettings();
    }

    public void saveServerData() {
        RealmsClient client = RealmsClient.createRealmsClient();
        try {
            client.update(this.serverData.id, this.serverData.getName(), this.serverData.getDescription());
        }
        catch (RealmsServiceException e) {
            LOGGER.error("Couldn't save settings");
            Realms.setScreen((RealmsScreen)new RealmsGenericErrorScreen(e, (RealmsScreen)this));
            return;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Couldn't save settings");
        }
        Realms.setScreen((RealmsScreen)this);
    }

    public void saveSettings(String name, String desc) {
        String description = desc == null || desc.trim().equals("") ? null : desc;
        this.serverData.setName(name);
        this.serverData.setDescription(description);
        this.saveServerData();
    }

    @Override
    void callback(WorldTemplate worldTemplate) {
        if (worldTemplate == null) {
            return;
        }
        if (worldTemplate.minigame) {
            this.switchMinigame(worldTemplate);
        }
    }

    public void switchSlot() {
        RealmsTasks.SwitchSlotTask switchSlotTask = new RealmsTasks.SwitchSlotTask(this.serverData.id, this.hoveredSlot, this.getNewScreen());
        RealmsLongRunningMcoTaskScreen longRunningMcoTaskScreen = new RealmsLongRunningMcoTaskScreen(this.lastScreen, switchSlotTask);
        longRunningMcoTaskScreen.start();
        Realms.setScreen((RealmsScreen)longRunningMcoTaskScreen);
    }

    public void switchMinigame(WorldTemplate selectedWorldTemplate) {
        RealmsTasks.SwitchMinigameTask startMinigameTask = new RealmsTasks.SwitchMinigameTask(this.serverData.id, selectedWorldTemplate, this.getNewScreen());
        RealmsLongRunningMcoTaskScreen longRunningMcoTaskScreen = new RealmsLongRunningMcoTaskScreen(this.lastScreen, startMinigameTask);
        longRunningMcoTaskScreen.start();
        Realms.setScreen((RealmsScreen)longRunningMcoTaskScreen);
    }

    public void resetWorldWithTemplate(WorldTemplate template) {
        RealmsTasks.ResettingWorldTask resettingWorldTask = new RealmsTasks.ResettingWorldTask(this.serverId, this.lastScreen, template);
        RealmsLongRunningMcoTaskScreen longRunningMcoTaskScreen = new RealmsLongRunningMcoTaskScreen(this, resettingWorldTask);
        longRunningMcoTaskScreen.start();
        Realms.setScreen((RealmsScreen)longRunningMcoTaskScreen);
    }

    public void resetWorld(String seed, int levelType, boolean generateStructures) {
        RealmsTasks.ResettingWorldTask resettingWorldTask = new RealmsTasks.ResettingWorldTask(this.serverId, this.lastScreen, seed, levelType, generateStructures);
        RealmsLongRunningMcoTaskScreen longRunningMcoTaskScreen = new RealmsLongRunningMcoTaskScreen(this, resettingWorldTask);
        longRunningMcoTaskScreen.start();
        Realms.setScreen((RealmsScreen)longRunningMcoTaskScreen);
    }

    public RealmsConfigureWorldScreen getNewScreen() {
        return new RealmsConfigureWorldScreen(this.lastScreen, this.serverId);
    }
}

